<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function images()
    {
        return $this->morphMany('App\Models\Image');
    }

    public function coupons()
    {
        return $this->hasMany('App\Models\Coupon');
    }

    public function ratings()
    {
        return $this->hasMany('App\Models\Rating');
    }

    public function comments()
    {
        return $this->hasMany('App\Models\Comment');
    }

    public function offers()
    {
        return $this->hasMany('App\Models\Offer');
    }

    public function orders()
    {
        return $this->belongsToMany('App\Models\Order');
    }

    public function users()
    {
        return $this->belongsToMany('App\Models\User');
    }

}